﻿using UnityEngine;
using System.Collections;
using System.Collections.Generic;


public class LoadLevel : MonoBehaviour {


    //singleton
    public static LoadLevel instance;

    //liste des blocs dispo
    public Object[] levelsPrefabs;

    public GameObject submarinePrefab;

    //lvl en cours
    public int currentLevel;

   public GameObject parent;
   public GameObject parentsub;

    void Awake()
    {
        instance = this;
    }

    //booleen indiquant chargement
    [HideInInspector]
    public bool loadingInProgress = false;

    

    public void LoadLvl(int numLevel)
    {

        currentLevel = numLevel;
        loadingInProgress = true;

        if (true)
        {
            CreateLevel(numLevel);
        }
    }



    //create the level-----------------------------------------------------------------------------
    void CreateLevel(int numLvl)
    {
        Destroy(parent);
        Destroy(parentsub);
       

        parent = new GameObject();
        parentsub = new GameObject();

        int x=-500, y=0,z=0;

        if (numLvl == 2)
        {
            z =8000 ;
        }

        if (numLvl == 3)
        {
            z = 16000;
        }



        GameObject newLevel = Instantiate(levelsPrefabs[numLvl-1], new Vector3(x, y,z), Quaternion.identity) as GameObject;
        newLevel.transform.parent = parent.transform;

        Transform submarinePosition = newLevel.transform.Find("submarinePos");

        GameObject submarine = Instantiate(submarinePrefab, submarinePosition.position, Quaternion.identity) as GameObject;
        submarine.transform.parent = parentsub.transform;

        HealthSubmarine.HealthPoints = 100;

        StateMachine.instance.SetState(STATE.PLAY);
    }
}
